let FeatureNames = {
    LandingPage: 'LandingPage',
    LoginSystem: 'LoginSystem',
    CommentFunctionality: 'CommentFunctionality',
    SharingFunctionality: 'SharingFunctionality',
    PaymentSystem: 'PaymentSystem',
    ImageUpload: 'ImageUpload',
    ContentManagementSystem: 'ContentManagementSystem',
    ChatSystem: 'ChatSystem',
    VideoFunctionality: 'VideoFunctionality',
    ImapService: 'ImapService'
};

let Features = [
    {
        name: FeatureNames.LandingPage,
        employeeLevel: EmployeeLevels.Beginner,
        requirements: {
            FrontendModule: 2,
            InputModule: 1,
        },
        requiredComputeUnit: 50,
        hype: 10,
    },
    {
        name: FeatureNames.LoginSystem,
        employeeLevel: EmployeeLevels.Beginner,
        requirements: {
            FrontendModule: 1,
            InputModule: 1,
            BackendModule: 1,
            AuthenticationModule: 1,
        },
        requiredComputeUnit: 50,
        hype: 14,
    },
    {
        name: FeatureNames.CommentFunctionality,
        employeeLevel: EmployeeLevels.Beginner,
        requirements: {
            BackendModule: 2,
            FrontendModule: 2,
            InputModule: 1,
            NotificationModule: 1,
        },
        requiredComputeUnit: 50,
        hype: 18,
    },
    {
        name: FeatureNames.SharingFunctionality,
        employeeLevel: EmployeeLevels.Beginner,
        requirements: {
            InterfaceModule: 1,
            EmailModule: 2,
            ApiClientModule: 2,
            BackendModule: 2,
        },
        requiredComputeUnit: 50,
        hype: 16,
    },
    {
        name: FeatureNames.PaymentSystem,
        employeeLevel: EmployeeLevels.Intermediate,
        requirements: {
            BackendModule: 4,
            PaymentGatewayModule: 4,
            EmailModule: 2,
        },
        requiredComputeUnit: 50,
        hype: 20,
    },
    {
        name: FeatureNames.ImageUpload,
        employeeLevel: EmployeeLevels.Intermediate,
        requirements: {
            InputModule: 2,
            StorageModule: 3,
            DatabaseLayer: 2,
            BackendModule: 2,
        },
        requiredComputeUnit: 50,
        hype: 22,
    },
    {
        name: FeatureNames.ContentManagementSystem,
        employeeLevel: EmployeeLevels.Intermediate,
        requirements: {
            ContentManagementModule: 5,
            InputModule: 4
        },
        requiredComputeUnit: 50,
        hype: 22,
    },
    {
        name: FeatureNames.ChatSystem,
        employeeLevel: EmployeeLevels.Expert,
        requirements: {
            InputModule: 2,
            NotificationModule: 4,
            NetworkComponent: 5
        },
        requiredComputeUnit: 50,
        hype: 28,
    },
    {
        name: FeatureNames.VideoFunctionality,
        employeeLevel: EmployeeLevels.Expert,
        requirements: {
            DatabaseLayer: 3,
            StorageModule: 5,
            NetworkComponent: 3,
            VideoComponent: 6,
        },
        requiredComputeUnit: 50,
        hype: 26,
    },
    {
        name: FeatureNames.ImapService,
        employeeLevel: EmployeeLevels.Expert,
        requirements: {
            DatabaseLayer: 4,
            AuthenticationModule: 3,
            FilesystemComponent: 1,
            EmailModule: 6,
        },
        requiredComputeUnit: 50,
        hype: 22,
    },
];

